/*==============================================================================
PART 3: Table A3
==============================================================================
Purpose:
This script generates Table A3 of the manuscript.
Regression of net non-interest expense on balance sheet components,
including deposit categories and size interactions.

Input:
- $path_temp/deposit_cost_reg*_restults.ster (Stored regression estimates from part 2b - * in 1:4)
Output:
- $path_tables/table_a4_panel_a.tex (LaTeX file for Table A3, Panel A)
- $path_tables/table_a4_panel_b.tex (LaTeX file for Table A3, Panel B)

Last updated: July 03, 2025
==============================================================================*/

display "--- Generating Table A3 ---"

est clear
forvalues i = 1/4 {
    local file "deposit_cost_reg`i'.ster"
    display "Loading `file'..."
    est use "$path_temp/`file'"
    est sto reg`i'

    if `i'==4 {
        local num = e(N)
        local Obs_lab = substr("`num'",1,2) + "," + substr("`num'",3,5)
    }
}

* Prepare estimates for -estout-
estfe reg1 reg2 reg3 reg4, labels(yq "Time FE")
return list
esttab reg1 reg2 reg4 using "$path_tables/table_a3.tex", wide ///
	prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" "\begin{tabular*}{\textwidth}{@{\hskip\tabcolsep\extracolsep\fill}l*{6}{S[table-format=1.3, input-ignore={,}]}}" "\hline\hline" " &\multicolumn{6}{c}{Net non-interest expense \%}" "\\\cmidrule(lr){2-7}")  ///
	indicate("Controls = *foreigndep_assets" `r(indicate_fe)', labels("{Yes}" "{No}")) width(0.8\textwidth) nogaps /// //indicate("Time FE=0.yq") ///
	cells("b(fmt(3) star) se(fmt(3) par({( )}))") mlabels(,none) collabels(,none) /// //(par(( ))
	b(%8.3f) se(%8.3f par(" {(" ")} ")) sfmt(%12.0fc %9.3fc) /// 
	order(coredep_assets uninszm_assets inszm_assets stdep_assets 1.sizeq#c.inszm_assets 2.sizeq#c.inszm_assets 3.sizeq#c.inszm_assets 4.sizeq#c.inszm_assets 1.sizeq#c.stdep_assets 2.sizeq#c.stdep_assets 3.sizeq#c.stdep_assets 4.sizeq#c.stdep_assets _cons 2.sizeq 3.sizeq 4.sizeq) ///
	coeflabels(coredep_assets "Core dep \%" uninszm_assets "\\Uninsured ZM dep \%" inszm_assets "\\Insured ZM dep \%" stdep_assets "\\Small time dep \%" 1.sizeq#c.inszm_assets "\\Insured ZM dep \% $\times$ Size \\\hspace{0.5cm}1" 2.sizeq#c.inszm_assets "\hspace{0.5cm}2" 3.sizeq#c.inszm_assets "\hspace{0.5cm}3" 4.sizeq#c.inszm_assets "\hspace{0.5cm}4" 1.sizeq#c.stdep_assets "\\Small time dep \% $\times$ Size \\\hspace{0.5cm}1" 2.sizeq#c.stdep_assets "\hspace{0.5cm}2" 3.sizeq#c.stdep_assets "\hspace{0.5cm}3" 4.sizeq#c.stdep_assets "\hspace{0.5cm}4" sizeq1 "ADD Size \\\hspace{0.5cm}1" sizeq2 "\hspace{0.5cm}2" sizeq3 "\hspace{0.5cm}3" sizeq4 "\hspace{0.5cm}4" _cons "Size \\\hspace{0.5cm}1" 2.sizeq "\hspace{0.5cm}2" 3.sizeq "\hspace{0.5cm}3" 4.sizeq "\hspace{0.5cm}4") ///
	noobs scalars("N Obs." "r2 \$R^2\$")  nomtitles /// //stats("N Obs." "r2 \$R^2\$") 
	msign("-") replace substitute(\_ _) starlevels(* 0.10 ** 0.05 *** 0.01) nonotes drop(*obm_assets *equity_assets *otherliabilities_assets *loans_assets *liabilities_assets tradingassets_assets *otherassets_assets 1.sizeq)

display "--- Table 3 $path_tables/table_a3.tex ---"
